package MusicLandscape.util.comparators;

import MusicLandscape.entities.Track;

import java.util.Comparator;

/**
 * @author Jonas Altrock (ew20b126@technikum-wien.at)
 * @version 1
 * @since LabWork
 */
public class YearComparator implements Comparator<Track> {
    /**
     * Compare two tracks by year.
     *
     * @param o1 the first object to be compared.
     * @param o2 the second object to be compared.
     * @return a negative integer, zero, or a positive integer as the
     * first argument is less than, equal to, or greater than the
     * second.
     * @throws NullPointerException if an argument is null and this
     *                              comparator does not permit null arguments
     * @throws ClassCastException   if the arguments' types prevent them from
     *                              being compared by this comparator.
     */
    @Override
    public int compare(Track o1, Track o2) {
        return Integer.compare(o1.getYear(), o2.getYear());
    }

    /**
     * nice name for this comparator
     *
     * @return a string representation of the object.
     */
    @Override
    public String toString() {
        return "by year";
    }
}
